// DioControlDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DioControl.h"
#include "DioControlDlg.h"
#include "StcLedBtn.h"

#include "../common/ceSDK.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TIMER_DIOSTATE 0

#define EXPECTED_NODECOUNT	10
#define TIMEOUT	(10*100) //  ϳ 100ms

#define TIMER_INTV 50

LONG g_nErrCode;

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDioControlDlg dialog

CDioControlDlg::CDioControlDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDioControlDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDioControlDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_nNodeCnt = 0;
	m_nCurNode = 0;
}

void CDioControlDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	INT i =0;
	//{{AFX_DATA_MAP(CDioControlDlg)
	for( i =0; i < DEF_MAXCNTRL; i++ )
	{
		DDX_Control(pDX, IDC_CMB_DIOLOGIC1 + i, m_cmbDioLogic[i]);
	}
	for( i =0; i < DEF_MAXCNTRL; i++ )
	{
		DDX_Control(pDX, IDC_CMB_DIOMODE1 + i, m_cmbDioMode[i]);
	}
	for( i =0; i < DEF_MAXCNTRL; i++ )
	{
		DDX_Control(pDX, IDC_PIC_DIOLED1 + i, m_stcDioCntrl[i]);
	}
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDioControlDlg, CDialog)
	//{{AFX_MSG_MAP(CDioControlDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_DIOLOGICAPPLY, OnBtnDioLogicApplyClicked)
	ON_BN_CLICKED(IDC_BTN_DIOMODEAPPLY, OnBtnDioModeApplyClicked)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDioControlDlg message handlers

BOOL CDioControlDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	if( !ceLoadDll() ) //DLL εմϴ.
	{
		AfxMessageBox("Load Dll Fail");
		return TRUE;
	}

	LONG nErrCode = 0;
	//̽ ε մϴ.
	if( ceGnLoad() != ceERR_NONE ) 
	{
		OutputDebugString( "\n[ceGnLoad Error!]\n" );
		return FALSE;
	}		

	long nIsSearchedDev = 0;

	//̹ ˻  Ȯմϴ.
	ceGnIsSearchedDevice( &nIsSearchedDev );

	if ( nIsSearchedDev == CE_FALSE )
	{
		//ڴ   , ŸӾƿ, , ãƳ   Դϴ.
		if( ceGnSearchDevice(EXPECTED_NODECOUNT, TIMEOUT, FALSE, &m_nNodeCnt) != ceERR_NONE ) {
			OutputDebugString( "\n[ceGnSearchDevice Error]\n" );
			return FALSE;
		}		
	}
	else
	{
		//带 ˻մϴ.
		if((g_nErrCode = ceGnReSearchDevice(EXPECTED_NODECOUNT, TIMEOUT, FALSE, &m_nNodeCnt)) < 0) {
			OutputDebugString( "\n[ceGnReSearchDevice Error]\n" );
			return FALSE;
		}		
	}

	LONG nFirstDioId = 0;
	FindFrstDio(&nFirstDioId); //DIO  ִ 带 ãϴ.
	UpdateControl( nFirstDioId ); //ư 뵵 մϴ.
	UpdateDioMode(); //Dio Mode ޺ ڽ Ʈ մϴ.
	UpdateDioLogic(); //Dio Logic ޺ ڽ Ʈ մϴ.

	SetTimer( TIMER_DIOSTATE, TIMER_INTV, NULL );
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDioControlDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDioControlDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDioControlDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDioControlDlg::OnDestroy()
{
	ceGnUnload();	//̽ εմϴ.
	ceUnloadDll();	//DLL Unloadմϴ.

	CDialog::OnDestroy();
}

/************************************************************************/
/* ư Ȱ ϰ Ÿ̸Ӹ  ŵϴ.                     */ 
/************************************************************************/
VOID CDioControlDlg::UpdateControl( LONG nNodeId )
{
	if( nNodeId < 0 ) return ;

	KillTimer(TIMER_DIOSTATE);

	LONG nModuleCnt = 0;

	ceGnModuleCount_Dio( nNodeId, &nModuleCnt );
	if( nModuleCnt < 0 ) return;

	LONG nIoMask = 0;
	BOOL bDioMode = 0;

	cedioModeMulti_Get(0, DEF_MAXCNTRL, &nIoMask );
	
	for( INT i = 0; i < DEF_MAXCNTRL; i++ )
	{
		bDioMode = ( nIoMask >> i ) & 0x01 ? DO_MODE : DI_MODE;
		m_stcDioCntrl[i].SetChnlNMode( i, static_cast<LONG>( bDioMode ) );
	}

	SetTimer(TIMER_DIOSTATE, TIMER_INTV, NULL);
}

/************************************************************************/
/* DIO ϴ 带 ãϴ.                                      */
/************************************************************************/
VOID CDioControlDlg::FindFrstDio( LONG* nNodeNum )
{
	if( m_nNodeCnt < 0 ) return;

	LONG nNodeIP, nNodeID, nNodeInGlobal, nModuleIdx, nModuleChnl;
	ceGnLocalDIO_Get( 0, &nNodeIP, &nNodeID, &nNodeInGlobal, &nModuleIdx, &nModuleChnl );
	
	*nNodeNum = nNodeID;
}

/************************************************************************/
/*  DIO Mode Ű ԼԴϴ.                             */
/************************************************************************/
VOID CDioControlDlg::OnBtnDioModeApplyClicked()
{
	LONG nModeMask = 0;
	INT nCurSel = 0;
	BOOL bMode = FALSE;

	for( INT i = 0; i < DEF_MAXCNTRL; i++ )
	{
		nCurSel = m_cmbDioMode[i].GetCurSel();
		bMode = nCurSel ? DO_MODE : DI_MODE;

		if( bMode == DO_MODE )
		{
			nModeMask |= ( 0x01 << i );
		}
		else //bMode ==DI_MODE
		{
			nModeMask &= ~( 0x01 << i );
		}
	}

	cedioModeMulti_Set( 0, DEF_MAXCNTRL, nModeMask );

	LONG nNodeId = 0;
	FindFrstDio( &nNodeId );
	UpdateControl( nNodeId );

	UpdateDioMode();
}

/************************************************************************/
/*  DIO Logic  Ű ԼԴϴ.                           */
/************************************************************************/
VOID CDioControlDlg::OnBtnDioLogicApplyClicked()
{
	LONG nLogicMask = 0;
	INT nCurSel = 0;
	BOOL bLogic = FALSE;

	for( INT i = 0; i < DEF_MAXCNTRL; i++ )
	{
		nCurSel = m_cmbDioLogic[i].GetCurSel();
		bLogic = nCurSel ? LOGIC_B : LOGIC_A;

		if( bLogic == LOGIC_B )
		{
			nLogicMask |= ( 0x01 << i );
		}
		else //bMode == LOGIC_A
		{
			nLogicMask &= ~( 0x01 << i );
		}
	}

	cedioLogicMulti_Set( 0, DEF_MAXCNTRL, nLogicMask );

	UpdateDioLogic();
}

VOID CDioControlDlg::OnTimer(UINT nIDEvent)
{
	switch( nIDEvent )
	{
	case TIMER_DIOSTATE:
		UpdateDIOState();
		break;
	}
	CDialog::OnTimer(nIDEvent);
}

/************************************************************************/
/* DIO  ¸ о ư Ʈ ϴ Լ Դϴ.           */
/************************************************************************/
VOID CDioControlDlg::UpdateDIOState()
{
	LONG nDioState = 0;
	LONG nDioCnt = 0;
	BOOL bDioSet = 0;
	
	cedioMulti_Get( 0, DEF_MAXCNTRL, &nDioState );
	
	for( INT i = 0; i < DEF_MAXCNTRL; i++ )
	{
		bDioSet = ( nDioState >> i ) & 0x01 ? TRUE : FALSE;
		m_stcDioCntrl[i].SetBmp( bDioSet );
	}
}

/************************************************************************/
/* Mode  ޺ ڽ Ʈ մϴ.                               */
/************************************************************************/
VOID CDioControlDlg::UpdateDioMode()
{
	if( m_nNodeCnt < 1 ) return;
	LONG nModeMask = 0;
	LONG nCurSel = 0;

	cedioModeMulti_Get( 0, DEF_MAXCNTRL, &nModeMask );

	for( INT i =0; i < DEF_MAXCNTRL; i++ )
	{
		nCurSel = ( nModeMask >> i ) & 0x01 ? DO_MODE : DI_MODE;
		m_cmbDioMode[i].SetCurSel( nCurSel );
	}
}

/************************************************************************/
/* Logic ޺ ڽ Ʈ մϴ.                               */
/************************************************************************/
VOID CDioControlDlg::UpdateDioLogic()
{
	if( m_nNodeCnt < 1 ) return;
	LONG nLogicMask =0;
	LONG nCurSel =0;

	cedioLogicMulti_Get( 0, DEF_MAXCNTRL, &nLogicMask );

	for( INT i = 0; i < DEF_MAXCNTRL; i++ )
	{
		nCurSel = ( nLogicMask >> i ) & 0x01 ? LOGIC_B : LOGIC_A;
		m_cmbDioLogic[i].SetCurSel( nCurSel );
	}
}
